from django.http import JsonResponse
from django.shortcuts import render, get_object_or_404, redirect
from back.models import Group, Item, ApiUser, Previews
from preview import settings

def home(request):
    return render(request, 'home.html')

def done(request, id):
    user = get_object_or_404(ApiUser, url_for_search=id)
    previews = Previews.objects.filter(user_for=user)

    items = []
    for preview in previews:
        items.append({
            'name': preview.name,
            'image_url': request.build_absolute_uri(settings.MEDIA_URL + str(preview.image))
        })

    return render(request, 'done.html', {'items': items})

def index(request, id):
    if not ApiUser.objects.filter(url_for_search=id).exists():
        return redirect('notfound')
    user = get_object_or_404(ApiUser, url_for_search=id)
    try:
        logo = user.logo.url
    except ValueError:
        logo = False
        print("ERROR WITH LOGO")
    try:
        Plokstes = Item.objects.filter(specification='Plokstes', user_for=user).first().image.url
        Takai=Item.objects.filter(specification='Takai', user_for=user).first().image.url
        Sonai=Item.objects.filter(specification='Sonai', user_for=user).first().image.url
        Paminklai=Item.objects.filter(specification='Paminklai', user_for=user).first().image.url
    except AttributeError:
        Plokstes = Takai = Sonai = Paminklai= 0
    ans = {'show_prices': user.show_prices,
        'show_dimensions': user.show_sizes,
        'show_upper_button': user.show_upper_button,
        'show_lower_button': user.show_lower_button,
        'show_lower_lower_button': user.show_lower_lower_button,
        'show_logo_on_main_page': user.show_logo_on_main_page,
        'show_logo_on_preview': user.show_logo_on_preview,
        'title_for_upper_button': user.title_for_upper_button,
        'title_for_lower_button': user.title_for_lower_button,
        'title_for_lower_lower_button': user.title_for_lower_lower_button,
        'url_for_lower_lower_button': user.url_for_lower_lower_button,
        'url_for_upper_button': user.url_for_upper_button,
        'url_for_lower_button': user.url_for_lower_button,
           'items': [i[0] for i in Group.objects.all().filter(user_for=user).values_list('name')],
           'photos': {'Paminklai': Paminklai, 'Sonai': Sonai, 'Takai': Takai, 'Plokstes': Plokstes},
           'logo': logo,
           
           'email': user.email}
    print(user.show_lower_lower_button, user.show_logo_on_main_page, user.show_logo_on_preview)
    return render(request, 'index.html', context=ans)


def notfound(request):
    return render(request, 'notfound.html')

'''
('Paminklai', 'Paminklai'),
        ('', 'Sonai'),
        ('', 'Takai'),
        ('', 'Plokstes')




<button id="id_for_but"
                        class="px-5 py-2 rounded-2xl font-semibold shadow transition-colors duration-200 bg-blue-600 text-white"
                        data-type="Didesnė">Didesnė</button>
'''