import rest_framework.viewsets
from django.forms import model_to_dict
from django.http import JsonResponse
from rest_framework.generics import get_object_or_404

from api.serializers import ItemSerializer
from back.models import Item


def components(request):
    type1 = request.GET.get('type', '')
    specification = request.GET.get('specification', '')
    print(type1, specification)
    ans = [{'id': i[0], 'name': i[1], 'image_url': 'media/'+i[2]} for i in Item.objects.filter(related=type1, specification=specification).order_by('position').values_list('id', 'name', 'image')]
    print(ans)
    return JsonResponse(
        status=200,
        data=ans,
        safe=False
    )

def image(request):
    id1 = int(request.GET.get('id', ''))
    item = get_object_or_404(Item, pk=id1)
    print(item)
    return JsonResponse(
        status=200,
        data={'image_url': item.image.url},
    )
