from django.contrib.auth.models import AbstractUser
from django.db import models

class ApiUser(AbstractUser):
    ...

    def __str__(self):
        return self.username

class Item(models.Model):
    name = models.CharField(max_length=64, default=False, null=False)
    related = models.CharField(choices=[('Didesne', 'Didesne'), ('Vienviete', 'Vienviete')], max_length=10 ,blank=False, null=False)
    specification = models.CharField(choices=[
        ('Paminklai', 'Paminklai'),
        ('Sonai', 'Sonai'),
        ('Takai', 'Takai'),
        ('Plokstes', 'Plokstes')
    ], max_length=10 ,blank=False, null=False)
    image = models.ImageField(upload_to='media/', blank=False, null=False)
    position = models.PositiveIntegerField(default=1, blank=True)

    def __str__(self):
        return f'{self.related} {self.specification}, {self.pk}'
