from django import forms
from django.contrib.auth.forms import UserCreationForm, AuthenticationForm
from django.contrib.auth import get_user_model
from django.core.exceptions import ValidationError
from django.utils.translation import gettext_lazy as _

User = get_user_model()

class CustomUserCreationForm(UserCreationForm):
    email = forms.EmailField(
        label=_("Email"),
        widget=forms.EmailInput(attrs={
            'placeholder': ' ',
            'class': 'form-control input-with-icon',
            'autocomplete': 'email'
        })
    )
    
    # Добавляем поле для условий использования
    terms = forms.BooleanField(
        required=True,
        error_messages={'required': _('Turite sutikti su naudojimo sąlygomis.')}
    )

    class Meta:
        model = User
        fields = ('email', 'first_name', 'last_name', 'password1', 'password2')

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        # Настраиваем поля
        self.fields['first_name'].widget.attrs.update({
            'class': 'form-control input-with-icon',
            'placeholder': ' '
        })
        self.fields['last_name'].widget.attrs.update({
            'class': 'form-control input-with-icon',
            'placeholder': ' '
        })
        self.fields['password1'].widget.attrs.update({
            'class': 'form-control input-with-icon',
            'placeholder': ' '
        })
        self.fields['password2'].widget.attrs.update({
            'class': 'form-control input-with-icon',
            'placeholder': ' '
        })
        
    def clean_email(self):
        email = self.cleaned_data.get('email')
        if User.objects.filter(email=email).exists():
            raise ValidationError(_('Vartotojas su šiuo el. pašto adresu jau egzistuoja.'))
        return email

class CustomAuthenticationForm(AuthenticationForm):
    username = forms.EmailField(
        label=_("Email"),
        widget=forms.EmailInput(attrs={
            'placeholder': ' ',
            'class': 'form-control input-with-icon',
            'autocomplete': 'email'
        })
    )
    password = forms.CharField(
        label=_("Password"),
        strip=False,
        widget=forms.PasswordInput(attrs={
            'placeholder': ' ',
            'class': 'form-control input-with-icon',
            'autocomplete': 'current-password'
        }),
    )

    error_messages = {
        'invalid_login': _(
            "Please enter a correct email and password. Note that both fields may be case-sensitive."
        ),
        'inactive': _("This account is inactive."),
    }