import os
import django
import random
import datetime
from decimal import Decimal


os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'finance.settings')
django.setup()
from spendings.models import Tag, Expense

from django.contrib.auth import get_user_model

User = get_user_model()

NUM_EXPENSES_PER_USER = 200  # Количество трат для каждого пользователя
DESCRIPTIONS = [
    "Покупка продуктов", "Оплата коммунальных услуг", "Транспортные расходы",
    "Обед в ресторане", "Покупка одежды", "Аптека", "Техника", "Книги",
    "Подарки", "Путешествия", "Образовательные курсы", "Развлечения"
]
TAG_COLORS = ["#FF5733", "#33FF57", "#3357FF", "#F333FF", "#33FFF3", "#F3FF33"]


def create_expenses():
    for user in User.objects.all():
        print(f"Обработка пользователя: {user.username}")

        # Создаем теги по умолчанию, если их нет
        tags = Tag.objects.filter(user=user)
        if not tags.exists():
            tags = [
                Tag.objects.create(user=user, name=f"Тег {i + 1}", color=random.choice(TAG_COLORS))
                for i in range(5)
            ]
            print(f"Создано 5 тегов для пользователя {user.username}")
        else:
            tags = list(tags)

        # Создаем траты
        for i in range(NUM_EXPENSES_PER_USER):
            # Генерация случайной даты за последние 2 года
            start_date = datetime.date.today() - datetime.timedelta(days=730)
            random_date = start_date + datetime.timedelta(days=random.randint(0, 730))

            # Генерация случайной суммы
            amount = Decimal(random.uniform(1, 1000)).quantize(Decimal('0.01'))

            # Создание траты
            expense = Expense.objects.create(
                user=user,
                date=random_date,
                amount=amount,
                description=f"{random.choice(DESCRIPTIONS)} #{i + 1}"
            )

            # Добавляем случайные теги (0-3 тега на трату)
            if tags:
                num_tags = random.randint(0, min(3, len(tags)))
                selected_tags = random.sample(tags, num_tags)
                expense.tags.set(selected_tags)

            if (i + 1) % 50 == 0:
                print(f"Создано {i + 1} трат...")

        print(f"Для пользователя {user.username} создано {NUM_EXPENSES_PER_USER} трат\n")


if __name__ == "__main__":
    create_expenses()
    print("Генерация трат завершена!")