from django.urls import path
from rest_framework.viewsets import ModelViewSet

from partners.views import ModelViewListCreatePartners, ModelViewRetrieveUpdateDestroyPartners, partners, \
    DocumentListView, DocumentUploadView, DocumentDeleteView

urlpatterns = [
    path('partners', partners, name='partners'),
    path('api/', ModelViewListCreatePartners.as_view(), name='partners_api'),
    path('api/<int:pk>/', ModelViewRetrieveUpdateDestroyPartners.as_view()),
    path('<int:partner_id>/documents/', DocumentListView.as_view(), name='partner-documents'),
    path('<int:partner_id>/documents/upload/', DocumentUploadView.as_view(), name='partner-document-upload'),
    path('documents/<int:doc_id>/delete/', DocumentDeleteView.as_view(), name='partner-document-delete'),
]
