import os
import django
import random

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'finance.settings')
django.setup()

from products.models import Product
from back.models import User

user = User.objects.all().get(email='123@gmail.com')
print(user)
if user:
    for i in range(50):
        Product.objects.create(
            user=user,
            name=f"Продукт {i+1}",
            discount=random.randint(0, 20),
            price=random.randint(10, 1000),
            unit=random.choice(['шт.', 'кг', 'уп.']),
            vat_rate=random.choice([0, 10, 20])
        )
    print(f"Создано 50 товаров для {user.email}")
else:
    print("Ошибка: Нет пользователей в базе данных")