from django.urls import path
from back import views
from back.views import payment_list, delete_company_logo

urlpatterns = [
    path('', views.LandingView.as_view(), name='landing'),
    path('registruotis/', views.register_view, name='register'),
    path('prisijungimas/', views.login_view, name='login'),
    path('logout/', views.logout_view, name='logout'),
    path('dashboard/', views.dashboard_view, name='dashboard'),
    path('profile/', views.profile_view, name='profile'),
    path('payments/', views.payments, name='payments'),
    path('payment/<int:payment_id>/pdf/', views.generate_invoice_pdf, name='generate_payment_pdf'),
    path('profile/', views.profile, name='profile'),
    path('payments_list/', payment_list, name='payments_list'),
    path('profile/delete-logo/', delete_company_logo, name='delete_company_logo'),

]

from django.conf import settings
from django.conf.urls import handler404, handler500

handler404 = 'core.views.custom_page_not_found'
handler500 = 'core.views.custom_server_error'