import os
import django
import random
import datetime
from decimal import Decimal
import uuid

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'finance.settings')
django.setup()

from back.models import User
from partners.models import Partner
from invoice.models import Payment
from settings.models import NumberingTemplate

NUM_PAYMENTS = 10000


def generate_items():
    """Генерирует случайные товары для платежа"""
    items = []
    total_amount = Decimal('0.00')
    num_items = random.randint(1, 5)

    for i in range(num_items):
        product_name = f"Товар {i + 1}"
        quantity = random.randint(1, 10)
        price = Decimal(random.uniform(10, 1000)).quantize(Decimal('0.01'))
        item_total = quantity * price
        total_amount += item_total

        items.append({
            "name": product_name,
            "quantity": quantity,
            "price": float(price),  # Для совместимости с JSONField
            "unit": random.choice(['шт.', 'кг', 'уп.'])
        })

    return items, total_amount


def main():
    for user in User.objects.filter(id=4):
        print(f"Обработка пользователя: {user.email}")

        # Получаем связанные данные
        partners = list(Partner.objects.filter(user=user))
        templates = list(NumberingTemplate.objects.filter(user=user))

        if not partners:
            print(f"! Пропуск: нет клиентов для пользователя {user.email}")
            continue

        for i in range(NUM_PAYMENTS):
            # Генерация основных данных
            client = random.choice(partners)
            items, amount = generate_items()
            start_date = datetime.date.today() - datetime.timedelta(days=730)  # 2 года назад

            # Генерация дат
            date_issued = start_date + datetime.timedelta(days=random.randint(0, 730))

            if random.random() > 0.2:  # 80% случаев
                date_due = date_issued + datetime.timedelta(days=random.randint(7, 60))
            else:
                date_due = None

            # Генерация статуса
            status = random.choice(['pending', 'paid', 'overdue', 'cancelled'])
            date_paid = None

            if status == 'paid':
                if date_due:
                    max_days = (date_due - date_issued).days
                    days_paid = random.randint(1, max(max_days, 1))
                else:
                    days_paid = random.randint(1, 60)
                date_paid = date_issued + datetime.timedelta(days=days_paid)

            # Создание платежа
            Payment.objects.create(
                user=user,
                client=client,
                invoice_number=f"INV-{uuid.uuid4().hex[:12]}",
                items=items,
                amount=amount,
                date_issued=date_issued,
                date_due=date_due,
                date_paid=date_paid,
                status=status,
                description=f"Тестовый платеж #{i + 1}",
                type='vnt',
                template=random.choice(templates) if templates else None
            )

        print(f"Создано {NUM_PAYMENTS} платежей для {user.email}")


if __name__ == "__main__":
    main()
    print("Генерация платежей завершена!")