
from django.contrib import admin
from django.conf.urls.static import static
from django.urls import path, include
from finance import settings

urlpatterns = [
    path('admin/', admin.site.urls),
    path('', include('back.urls')),
    path('invoice/', include('invoice.urls')),
    path('settings/', include('settings.urls')),
    path('partners/', include('partners.urls')),
    path('products/', include('products.urls')),
    path('expenses/', include('spendings.urls')),  # Приложение расходов

]
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
