from django.db import models
from django.utils.translation import gettext_lazy as _
from back.models import User


class Partner(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE, related_name='partners')
    name = models.CharField(_('name'), max_length=100, blank=True, null=True)  # Изменено
    contact_person = models.CharField(_('contact person'), max_length=100, blank=True, null=True)  # Изменено
    email = models.EmailField(_('email'), blank=True, null=True)  # Изменено
    phone = models.CharField(_('phone'), max_length=20, blank=True, null=True)  # Изменено
    address = models.TextField(_('address'), blank=True, null=True)  # Изменено

    vat_code = models.CharField(
        _('VAT Code'),
        max_length=50,
        blank=True,
        null=True,
        help_text=_('Tax identification number (VAT code)')
    )
    registration_number = models.CharField(
        _('Registration Number'),
        max_length=50,
        blank=True,
        null=True
    )

    created_at = models.DateTimeField(_('created at'), auto_now_add=True)
    updated_at = models.DateTimeField(_('updated at'), auto_now=True)

    def __str__(self):
        return self.name


class Document(models.Model):
    partner = models.ForeignKey(Partner, on_delete=models.CASCADE, related_name='documents')
    title = models.CharField(_('Title'), max_length=255)
    file = models.FileField(_('File'), upload_to='partner_documents/')
    uploaded_at = models.DateTimeField(_('Uploaded at'), auto_now_add=True)

    def __str__(self):
        return self.title

    class Meta:
        verbose_name = _('Document')
        verbose_name_plural = _('Documents')
