from rest_framework.serializers import ModelSerializer
from partners.models import Partner
from partners.models import Document

class DocumentSerializer(ModelSerializer):
    class Meta:
        model = Document
        fields = ['id', 'title', 'file', 'uploaded_at']
        read_only_fields = ['uploaded_at']

class SerializerPartners(ModelSerializer):
    class Meta:
        model = Partner
        fields = '__all__'
        extra_kwargs = {
            'name': {'required': False},
            'contact_person': {'required': False},
            'email': {'required': False},
            'phone': {'required': False},
            'address': {'required': False},
            'vat_code': {'required': False},
            'registration_number': {'required': False},
            'user': {'required': False},
        }
