# Generated by Django 4.2 on 2025-07-05 22:57

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Expense',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='Data')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10, verbose_name='Suma')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Aprašymas')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Išlaida',
                'verbose_name_plural': 'Išlaidos',
                'ordering': ['-date'],
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=100, verbose_name='Pavadinimas')),
                ('color', models.CharField(default='#0d6efd', max_length=7, verbose_name='Spalva')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tags', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Žyma',
                'verbose_name_plural': 'Žymos',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ExpenseFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(upload_to='expense_files/%Y/%m/%d/', validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf', 'jpg', 'jpeg', 'png'])], verbose_name='Failas')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('expense', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='files', to='spendings.expense')),
            ],
            options={
                'verbose_name': 'Išlaidų failas',
                'verbose_name_plural': 'Išlaidų failai',
            },
        ),
        migrations.AddField(
            model_name='expense',
            name='tags',
            field=models.ManyToManyField(blank=True, null=True, related_name='expenses', to='spendings.tag', verbose_name='Žymos'),
        ),
        migrations.AddField(
            model_name='expense',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='expenses', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddConstraint(
            model_name='tag',
            constraint=models.UniqueConstraint(fields=('user', 'name'), name='unique_tag_per_user'),
        ),
    ]
