# expenses/urls.py
from django.urls import path, include
from rest_framework.routers import DefaultRouter
from . import views

# Создаем роутер для API
router = DefaultRouter()
router.register(r'expenses', views.ExpenseViewSet, basename='expense')
router.register(r'tags', views.TagViewSet, basename='tag')

# URL для HTML представления и API
urlpatterns = [
    # HTML представление - страница управления расходами
    path('', views.ExpensesView.as_view(), name='expenses-html'),

    # API эндпоинты
    path('api/', include(router.urls)),

    # Специальные эндпоинты для файлов
    path('api/expenses/<int:expense_id>/files/<int:file_id>/',
         views.ExpenseViewSet.as_view({'delete': 'delete_file'}),
         name='expense-file-delete'),

    path('api/expenses/<int:expense_id>/files/<int:file_id>/download/',
         views.ExpenseViewSet.as_view({'get': 'download_file'}),
         name='expense-file-download'),
]